@extends('app.base')
@section('content')
    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" onclick="history.back()" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Potências - {{ $exe->ud }}</div>
        <div class="right" id="favorito">

        </div>
    </div>
    <!-- App Capsule -->
    <div id="appCapsule">
        <ul class="listview image-listview" style="margin-bottom: 50px;">
            @foreach ($potencias as $potencia)
                <li>
                    <a href="{{ route('app.lojas.cidades',$potencia->id) }}" class="item">
                        <img src="{{url('app')}}/assets/img/estados/{{$exe->thumb}}" alt="image" class="image">
                        <div class="in">
                            <div>{{utf8_decode($potencia->estadual)}}-{{utf8_decode($potencia->nome)}}</div>
                            <span class="text-muted"></span>
                        </div>
                    </a>
                </li>
            @endforeach
        </ul>
    </div>
    <!-- * App Capsule -->
@endsection
@section('js')

@endsection
